package com.ydl.ydlcommon.utils

import android.text.TextUtils
import com.ydl.ydlcommon.base.config.YDLConstants

/**
 * @author yuanwai
 * @描述:数据缓存
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/8
 */
class YDLCacheUtils {
    companion object {
        //测评首页缓存key
        private var CACHE_TEST_HOME = "testHomeData"
        //倾诉首页缓存key
        private var CACHE_CONFIDE_HOME = "confideHomeData"
        //课程优惠券时间获取时间缓存
        private var CACHE_COUPON_TIME = "cache_course_coupon_time_"
        //主页缓存
        private var CACHE_HOME_PAGER = "cache_home_pager"
        //专家列表页缓存（专家服务搜索页）
        private var CACHE_DOCTOR_LIST = "cache_doctor_list"
        //服务列表页缓存（专家服务搜索页）
        private var CACHE_SERVER_LIST = "cache_server_list"
        //课程分类列表页缓存
        private var CACHE_COURSE_LIST = "cache_course_list"
        //课程首页缓存
        private var CACHE_COURSE_HOME = "cache_course_home"
        //话题（问答）列表--最新（推荐）缓存
        private var CACHE_ASK_LIST_NEWEST = "cache_ask_list_newest"
        //话题（问答）列表--热门 缓存
        private var CACHE_ASK_LIST_POPULAR = "cache_ask_list_popular"
        //上次登录的手机号
        private var CACHE_USER_PHONE = "cache_user_phone"
        //上次登录的手机号的区号
        private var CACHE_USER_COUNTRY_PHONE_CODE = "cache_user_country_phone_code"
        //上次登录的发送登录验证码的时间
        private var CACHE_LOGIN_CODE_TIME = "cache_login_code_time_"
        //上次登录的发送忘记密码验证码的时间
        private var CACHE_RESET_CODE_TIME = "cache_reset_code_time_"
        //上次给专家发送留言的时间
        private var CACHE_SEND_MSG_TO_DOCTOR = "cache_send_msg_to_doctor_"
        //上次提醒用户给专家留言的时间
        private var CACHE_NOTICE_SEND_MSG_TO_DOCTOR = "cache_notice_send_msg_to_doctor_"
        //上次给邀请专家开通倾诉的时间
        private var CACHE_INVITE_DOCTOR_TIME = "cache_invite_doctor_time_"
        //上次提醒专家上线的时间
        private var CACHE_REMIND_DOCTOR_TIME = "cache_remind_doctor_time_"
        //上次推荐在线咨询师的时间
        private var CACHE_RECOMMEND_DOCTOR_TIME = "cache_recommend_doctor_time_"
        //搜索页面缓存
        private var CACHE_HOT_SEARCH_DATA = "cache_hot_search_data"
        //api
        private var CACHE_API = "cache_api"
        //冥想模块默认时间缓存
        private var CACHE_MUSE_DEFAULT_TIME = "cache_muse_default_time"

        /**
         * 保存冥想模块默认时间缓存
         */
        fun saveMuseDefaultTime(time: String) {
            SharedPreferencesEditor.putString(CACHE_MUSE_DEFAULT_TIME, time)
        }

        /**
         * 获取冥想模块默认时间缓存
         */
        fun getMuseDefaultTime(): String {
            return SharedPreferencesEditor.getString(CACHE_MUSE_DEFAULT_TIME)
        }

        /**
         * 根据sessionId保存提醒专家的时间
         */
        fun saveRecommendTime(sessionId: String, json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_RECOMMEND_DOCTOR_TIME + sessionId,
                json
            )
        }

        /**
         * 根据sessionId获取上次提醒该专家的时间
         */
        fun getRecommendTime(sessionId: String): String {
            return SharedPreferencesEditor.getString(CACHE_RECOMMEND_DOCTOR_TIME + sessionId)
        }

        /**
         * 根据sessionId保存提醒专家的时间
         */
        fun saveRemindTime(sessionId: String, json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_REMIND_DOCTOR_TIME + sessionId,
                json
            )
        }

        /**
         * 根据sessionId获取上次提醒该专家的时间
         */
        fun getRemindTime(sessionId: String): String {
            return SharedPreferencesEditor.getString(CACHE_REMIND_DOCTOR_TIME + sessionId)
        }

        /**
         * 保存倾诉首页数据
         */
        fun saveConfideHomeData(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_CONFIDE_HOME,
                json
            )
        }

        /**
         * 获取倾诉首页缓存
         */
        fun getConfideHomeData(): String {
            return SharedPreferencesEditor.getString(CACHE_CONFIDE_HOME)
        }

        /**
         * 保存测评首页数据
         */
        fun saveTestHomeData(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_TEST_HOME,
                json
            )
        }

        /**
         * 获取测评首页缓存
         */
        fun getTestHomeData(): String {
            return SharedPreferencesEditor.getString(CACHE_TEST_HOME)
        }

        /**
         * 保存首页首页数据
         */
        fun saveHomePagerData(json: String) {
            SharedPreferencesEditor.putString(
                CACHE_HOME_PAGER,
                json
            )
        }

        /**
         * 获取首页首页数据
         */
        fun getHomePagerData(): String {
            return SharedPreferencesEditor.getString(CACHE_HOME_PAGER)
        }

        /**
         * 保存优惠券接口调用时间
         */
        fun saveCouponTime(key: String?, json: String?) {
//            SharedPreferencesEditor.putString(CACHE_COUPON_TIME + key, json)
            //注释这行代码先留着：现在优惠券的逻辑是按设备每天只调用一次，后续版本会改成按用户每天调用一次
            SharedPreferencesEditor.putString(
                CACHE_COUPON_TIME + key,
                json
            )
        }

        /**
         * 获取优惠券接口调用时间
         */
        fun getCouponTime(key: String?): String {
//            return SharedPreferencesEditor.getString(CACHE_COUPON_TIME + key)
            //注释这行代码先留着：现在优惠券的逻辑是按设备每天只调用一次，后续版本会改成按用户每天调用一次
            return SharedPreferencesEditor.getString(CACHE_COUPON_TIME + key)
        }

        /**
         * 保存专家列表数据
         */
        fun saveDoctorListData(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_DOCTOR_LIST,
                json
            )
        }

        /**
         * 获取专家列表缓存
         */
        fun getDoctorListData(): String {
            return SharedPreferencesEditor.getString(CACHE_DOCTOR_LIST)
        }

        /**
         * 保存服务列表数据
         */
        fun saveServerListData(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_SERVER_LIST,
                json
            )
        }

        /**
         * 获取服务列表缓存
         */
        fun getServerListData(): String {
            return SharedPreferencesEditor.getString(CACHE_SERVER_LIST)
        }

        /**
         * 保存课程列表数据
         */
        fun saveCourseListData(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_COURSE_LIST,
                json
            )
        }

        /**
         * 获取课程列表缓存
         */
        fun getCourseListData(): String {
            return SharedPreferencesEditor.getString(CACHE_COURSE_LIST)
        }

        /**
         * 保存课程首页数据
         */
        fun saveCourseHomeData(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_COURSE_HOME,
                json
            )
        }

        /**
         * 获取课程首页缓存
         */
        fun getCourseHomeData(): String {
            return SharedPreferencesEditor.getString(CACHE_COURSE_HOME)
        }

        /**
         * 保存 话题（问答）列表--最新（推荐）数据
         */
        fun saveAskListNewstData(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_ASK_LIST_NEWEST,
                json
            )
        }

        /**
         * 获取 话题（问答）列表--最新（推荐）缓存
         */
        fun getAskListNewstData(): String {
            return SharedPreferencesEditor.getString(CACHE_ASK_LIST_NEWEST)
        }

        /**
         * 保存 话题（问答）列表--热门数据
         */
        fun saveAskListPopularData(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_ASK_LIST_POPULAR,
                json
            )
        }

        /**
         * 获取 话题（问答）列表--热门缓存
         */
        fun getAskListPopularData(): String {
            return SharedPreferencesEditor.getString(CACHE_ASK_LIST_POPULAR)
        }

        /**
         * 保存区号
         */
        fun saveCountryPhoneCode(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_USER_COUNTRY_PHONE_CODE,
                json
            )
        }

        /**
         * 获取区号
         */
        fun getCountryPhoneCode(): String {
            return SharedPreferencesEditor.getString(CACHE_USER_COUNTRY_PHONE_CODE)
        }

        /**
         * 保存手机号
         */
        fun saveUserPhone(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_USER_PHONE,
                json
            )
        }

        /**
         * 获取手机号
         */
        fun getUserPhone(): String {
            return SharedPreferencesEditor.getString(CACHE_USER_PHONE)
        }

        /**
         * 保存登录、注册、绑定手机号发送验证码的时间
         */
        fun saveCodeTime(phone: String, json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_LOGIN_CODE_TIME + phone,
                json
            )
        }

        /**
         * 保存登录、注册、绑定手机号发送验证码的时间
         */
        fun getCodeTime(phone: String): String {
            return if (TextUtils.isEmpty(SharedPreferencesEditor.getString(CACHE_LOGIN_CODE_TIME + phone))) {
                "0"
            } else {
                SharedPreferencesEditor.getString(CACHE_LOGIN_CODE_TIME + phone)
            }
        }

        /**
         * 保存重置密码发送验证码的时间
         */
        fun saveResetCodeTime(phone: String, json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_RESET_CODE_TIME + phone,
                json
            )
        }

        /**
         * 获取重置密码发送验证码的时间
         */
        fun getResetCodeTime(phone: String): String {
            return if (TextUtils.isEmpty(SharedPreferencesEditor.getString(CACHE_RESET_CODE_TIME + phone))) {
                "0"
            } else {
                SharedPreferencesEditor.getString(CACHE_RESET_CODE_TIME + phone)
            }
        }

        /**
         * 保存上次给专家留言的时间
         */
        fun saveSendMsgTime(userUid: String, doctorUid: String, json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_SEND_MSG_TO_DOCTOR + userUid + "_" + doctorUid,
                json
            )
        }

        /**
         * 获取上次给专家留言的时间
         */
        fun getSendMsgTime(userUid: String, doctorUid: String): String {
            return if (TextUtils.isEmpty(SharedPreferencesEditor.getString(CACHE_SEND_MSG_TO_DOCTOR + userUid + "_" + doctorUid))) {
                "0"
            } else {
                SharedPreferencesEditor.getString(CACHE_SEND_MSG_TO_DOCTOR + userUid + "_" + doctorUid)
            }
        }

        /**
         * 保存上次提醒用户给专家留言的时间
         */
        fun saveNoticeSendTime(userUid: String, doctorUid: String, json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_NOTICE_SEND_MSG_TO_DOCTOR + userUid + "_" + doctorUid,
                json
            )
        }

        /**
         * 获取上次提醒用户给专家留言的时间
         */
        fun getNoticeSendTime(userUid: String, doctorUid: String): String {
            return if (TextUtils.isEmpty(SharedPreferencesEditor.getString(CACHE_NOTICE_SEND_MSG_TO_DOCTOR + userUid + "_" + doctorUid))) {
                "0"
            } else {
                SharedPreferencesEditor.getString(CACHE_NOTICE_SEND_MSG_TO_DOCTOR + userUid + "_" + doctorUid)
            }
        }

        /**
         * 保存上次邀请专家时间
         */
        fun saveInviteTime(userUid: String, doctorUid: String, json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_INVITE_DOCTOR_TIME + userUid + "_" + doctorUid,
                json
            )
        }

        /**
         * 获取上次邀请专家时间
         */
        fun getInviteTime(userUid: String, doctorUid: String): String {
            return if (TextUtils.isEmpty(SharedPreferencesEditor.getString(CACHE_INVITE_DOCTOR_TIME + userUid + "_" + doctorUid))) {
                "0"
            } else {
                SharedPreferencesEditor.getString(CACHE_INVITE_DOCTOR_TIME + userUid + "_" + doctorUid)
            }
        }

        /**
         * 保存 搜索页面 数据
         */
        fun saveHotSearchData(json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_HOT_SEARCH_DATA,
                json
            )
        }

        /**
         * 获取 搜索页面 缓存
         */
        fun getHotSearchData(): String {
            return SharedPreferencesEditor.getString(CACHE_HOT_SEARCH_DATA)
        }

        /**
         * 保存api类型
         */
        fun saveCacheApi(@YDLConstants.AppEnv json: String?) {
            SharedPreferencesEditor.putString(
                CACHE_API,
                json
            )
        }

        /**
         * 获取api类型
         */
        fun getCacheApi(): String {
            return SharedPreferencesEditor.getString(CACHE_API)
        }
    }
}