package com.ydl.ydlcommon.utils.remind

import android.content.Context
import com.google.gson.JsonParseException
import com.ydl.ydlcommon.R
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.ToastUtil
import retrofit2.HttpException
import java.net.SocketTimeoutException
import java.net.UnknownHostException

class HttpErrorUtils private constructor() {

    companion object {
        private fun getInstance(): HttpErrorUtils {
            return Holder.INSTANCE
        }

        fun handleError(context: Context?, t: Throwable) {
            getInstance().handleError(context,t)
        }
    }

    fun handleError(context: Context?, t: Throwable) {
        t.printStackTrace()
        if (t is SocketTimeoutException || t is UnknownHostException || t is HttpException) {
            if (context != null) {
                ToastUtil.toastShort(context.getString(R.string.platform_network_error))
            }
        } else if (t is JsonParseException) {
            if (context != null) {
                ToastUtil.toastShort(context.getString(R.string.platform_gson_parse_error))
            }
        } else {
            //            ToastUtil.toastShort(context, t.getMessage());
            LogUtil.e(t.toString())
        }
    }

    private object Holder {
        val INSTANCE = HttpErrorUtils()
    }

}