package com.ydl.ydlcommon.view

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.text.TextUtils
import android.util.AttributeSet
import android.view.View
import android.widget.PopupWindow
import android.widget.RelativeLayout
import com.ydl.ydlcommon.R
import com.ydl.ydlcommon.data.PlatformDataManager
import com.ydl.ydlcommon.router.YdlCommonRouterManager
import com.ydl.ydlcommon.view.dialog.CommonDialog
import kotlinx.android.synthetic.main.platform_ui_new_more.view.*

/**
 * Created by Wi1ls on 2016/10/17;
 */
class MoreClickView @JvmOverloads constructor(private val mContext: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : RelativeLayout(mContext, attrs, defStyleAttr), View.OnClickListener {


    private var mPopupWindow: PopupWindow? = null

    private val work_time = if (PlatformDataManager.getRam().getGlobalInfo() == null) "早8:30-凌晨2:00" else PlatformDataManager.getRam().getGlobalInfo()?.info?.work_time
    private val tel = if (PlatformDataManager.getRam().getGlobalInfo() == null) "400-765-1010" else PlatformDataManager.getRam().getGlobalInfo()?.info?.tel

    init {
        View.inflate(mContext, R.layout.platform_ui_new_more, this)
        init()
    }

    internal fun init() {
        fl_main.setOnClickListener(this)
        more_msg.setOnClickListener(this)
        more_homepage.setOnClickListener(this)
        more_service.setOnClickListener(this)
        more_ray.setOnClickListener(this)

/*        if (YdlCommonRouterManager.getYdlCommonRoute().isHasUnread()) {
            msg_new.setVisibility(View.VISIBLE)
        } else {
            msg_new.setVisibility(View.INVISIBLE)
        }*/


    }


    override fun onClick(view: View) {
        if (mPopupWindow != null && mPopupWindow!!.isShowing) {
            mPopupWindow!!.dismiss()
        }
        when (view.id) {
            R.id.fl_main -> {
            }
            R.id.more_msg -> setMoreMsg()
            R.id.more_homepage -> setMoreHomePage()
            R.id.more_service -> setMoreService()
            R.id.more_ray -> setMoreRay()
        }

    }

    private fun setMoreMsg() {
        if (PlatformDataManager.getRam().getChannelName().startsWith("ATK_3")) {
            YdlCommonRouterManager.getYdlCommonRoute().startMain(context, 2, null)
        } else {
            YdlCommonRouterManager.getYdlCommonRoute().startMain(context, 3, null)
        }
    }

    private fun setMoreHomePage() {
        YdlCommonRouterManager.getYdlCommonRoute().startMain(context, 0, null)
    }

    private fun setMoreService() {
        YdlCommonRouterManager.getYdlCommonRoute().setMoreService(context)
/*        if (LoginHelper.getInstance().isLogin()) {
            SessionHelper.startP2PSession(context, -1, Constant.UID_SERVICE, null,
                    MyP2PMoreListener(Constant.UID_SERVICE,
                            context.getString(R.string.service), Constant.HEAD_SERVICE))
        } else {
            val intentv = Intent(context, ChooseLoginWayActivity::class.java)
            intentv.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            context.startActivity(intentv)
        }*/

    }

    private fun setMoreRay() {
        CommonDialog(context)
                .setMessage("欢迎致电壹点灵客服热线\n" + PlatformDataManager.getRam().getGlobalInfo()?.info?.tel + "\n服务时间:" + work_time)
                .setLeftOnclick("取消", null)
                .setRightClick("拨打") {
                    if (null != tel && !TextUtils.isEmpty(tel)) {
                        val phoneIntent = Intent(Intent.ACTION_DIAL, Uri.parse("tel:$tel"))
                        context.startActivity(phoneIntent)
                    }
                }.show()
    }

    private var callBack: CallPhoneCallBack? = null

    fun setCallPhoneCallBack(callBack: CallPhoneCallBack) {
        this.callBack = callBack
    }

    interface CallPhoneCallBack {
        fun call(tel: String, action: String)
    }

    fun setPopupWindow(popupWindow: PopupWindow) {
        mPopupWindow = popupWindow
    }
}
