package com.ydl.ydlcommon.view.banner;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.widget.ImageView;

import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.ydl.ydl_image.config.ISimpleImageOpConfig;
import com.ydl.ydl_image.config.SimpleImageOpConfiger;
import com.ydl.ydl_image.manager.YDLImageCacheManager;
import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydlcommon.R;
import com.ydl.ydlcommon.view.banner.loader.ImageLoader;

/**
 * Created by xiongyu on 2017/4/7.
 */

public class GlideImageDisplayLoader  extends ImageLoader {
    private int placeholderImage;//加载过程中的中间页面
    private int radius = 0;

    public GlideImageDisplayLoader() {
    }

    public GlideImageDisplayLoader(int placeholderImage) {
        this.placeholderImage = placeholderImage;
    }

    public GlideImageDisplayLoader(int placeholderImage, int radius) {
        this.placeholderImage = placeholderImage;
        this.radius = radius;
    }

    @Override
    public void displayImage(Context context, Object path, ImageView imageView) {

        if (placeholderImage > 0) {
            if (path instanceof String) {
                SimpleImageOpConfiger sp = new SimpleImageOpConfiger();
                sp.loadingPic = placeholderImage;
                sp.scaleType = ISimpleImageOpConfig.CENTER_CROP;
                sp.transform = ISimpleImageOpConfig.TRANSFORM_ROUND;
                sp.radius = radius;
                sp.transition = false;
                YDLImageCacheManager.showImage(context, (String) path, imageView, imageView.getWidth(), imageView.getHeight(), sp);
            }
        } else {
            if (path instanceof String) {
                if (imageView != null) {
                    imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                }
                YDLImageCacheManager.showImage(context, (String) path, imageView, imageView.getWidth());
            }
        }
    }
}
