package com.ydl.ydlcommon.view.dialog

import android.app.Activity
import android.app.Dialog
import android.os.Bundle
import android.view.View
import android.view.ViewGroup
import android.widget.AdapterView
import android.widget.ImageView
import com.umeng.socialize.bean.SHARE_MEDIA
import com.ydl.ydlcommon.R
import com.ydl.ydlcommon.actions.share.ShareMoreBean
import com.ydl.ydlcommon.actions.share.ShareUtils
import com.ydl.ydlcommon.adapter.CommonAdapter
import com.ydl.ydlcommon.view.BaseViewHolder
import kotlinx.android.synthetic.main.platform_share_custom_ui.*

/**
 * 自定义分享Dialog
 * Created by hgw on 2017/3/22.
 */

class CustomShareDialog(private val context: Activity) : Dialog(context, R.style.platform_transparentFrameWindowStyle), View.OnClickListener {


    private var share_title: String? = null
    private var share_url: String? = null
    private var share_context: String? = null
    private var share_head: String? = null
    private var list: List<ShareMoreBean>? = null

    private var adapter: CommonAdapter<ShareMoreBean>? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.platform_share_custom_ui)

        initView()

        val window = window
        // 设置显示动画
        window!!.setWindowAnimations(R.style.platform_main_menu_animstyle)
        val wl = window.attributes
        wl.x = 0
        wl.y = context.windowManager.defaultDisplay.height
        // 以下这两句是为了保证按钮可以水平满屏
        wl.width = ViewGroup.LayoutParams.MATCH_PARENT
        wl.height = ViewGroup.LayoutParams.WRAP_CONTENT

        // 设置显示位置
        onWindowAttributesChanged(wl)
        // 设置点击外围解散
        setCanceledOnTouchOutside(true)
    }

    private fun initView() {

        share_weichat.setOnClickListener(this)
        share_pyq.setOnClickListener(this)
        share_qqzone.setOnClickListener(this)
        share_qq.setOnClickListener(this)


        if (list == null || list!!.isEmpty()) {
            grid_view!!.visibility = View.GONE
            return
        } else {
            grid_view!!.visibility = View.VISIBLE
        }
        adapter = object : CommonAdapter<ShareMoreBean>() {
            override fun getView(position: Int, convertView1: View?, parent: ViewGroup): View {
                var convertView = convertView1
                val holder: BaseViewHolder
                if (convertView == null) {
                    convertView = layoutInflater.inflate(R.layout.platform_item_custom_share_ui, null)
                    holder = BaseViewHolder(convertView)
                    convertView!!.tag = holder
                } else {
                    holder = convertView.tag as BaseViewHolder
                }
                val imageView = holder.getView<ImageView>(R.id.share_img)
                //加载图标
                imageView.setImageResource(mDataList[position].imageResId)
                //设置title
                holder.setText(R.id.text_title, mDataList[position].actionName)
                return convertView
            }
        }
        grid_view!!.adapter = adapter
        grid_view!!.onItemClickListener = AdapterView.OnItemClickListener { _, _, position, _ ->
            val action = adapter!!.dataList[position].shareMoreAction
            action?.onClick()
            dismiss()
        }
        adapter!!.update(list)
    }

    //设置分享内容
    fun setShareBody(share_title: String, share_url: String, share_context: String, share_head: String) {
        this.share_title = share_title
        this.share_url = share_url
        this.share_context = share_context
        this.share_head = share_head
    }

    //添加扩展按钮
    fun addActions(list1: List<ShareMoreBean>) {
        this.list = list1
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.share_weichat -> {
                ShareUtils.shareTo(SHARE_MEDIA.WEIXIN, context, share_title!!, share_url!!, share_context!!, share_head)
                dismiss()
            }
            R.id.share_pyq -> {
                ShareUtils.shareTo(SHARE_MEDIA.WEIXIN_CIRCLE, context, share_title!!, share_url!!, share_context!!, share_head)
                dismiss()
            }
            R.id.share_qq -> {
                ShareUtils.shareTo(SHARE_MEDIA.QQ, context, share_title!!, share_url!!, share_context!!, share_head)
                dismiss()
            }
            R.id.share_qqzone -> {
                ShareUtils.shareTo(SHARE_MEDIA.QZONE, context, share_title!!, share_url!!, share_context!!, share_head)
                dismiss()
            }
        }
    }

    override fun show() {
        if (null == context) {
            return
        }
        if (context is Activity) {
            if (context.isFinishing) {
                return
            }
        }
        super.show()
    }
}

