package com.ydl.ydlcommon.view.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.ydlcommon.adapter.DialogListAdapter;
import com.ydl.ydlcommon.view.FullyLinearLayoutManager;
import com.ydl.ydlcommon.R;

import java.util.List;

//import com.yidianling.common.view.FullyLinearLayoutManager;


public class ListDialog extends Dialog {

    private Context mContext;

    public ListDialog(Context context) {
        super(context);
        mContext = context;
    }

    public ListDialog(Context context, int theme) {
        super(context, theme);
        mContext = context;
    }

    public static class Builder {
        //是否可以点击对话框外部
//		Boolean flag=true;
        private Context context; //上下文对象
        private List<String> mDatas;
        private View contentView; //对话框中间加载的其他布局界面
        private DialogListAdapter adapter;
        private String last_str; //最后一个按钮
        private OnClickListener Last_btnClickListener;
        private int itemTextColor;

        public interface OnItemClickLister {
            void onItemClick(Dialog dialog, View view, int position);

            void onItemLongClick(Dialog dialog, View view, int position);
        }

        private ListDialog.Builder.OnItemClickLister mOnItemClickLister;

        public Builder(Context context, List<String> mDatas, int itemTextColor) {
            this.context = context;
            this.mDatas = mDatas;
            this.itemTextColor = itemTextColor;
        }

        /**
         * 设置对话框界面
         *
         * @param v View
         * @return
         */
        public Builder setContentView(View v) {
            this.contentView = v;
            return this;
        }

        public ListDialog.Builder SetOnItemClickLister(ListDialog.Builder.OnItemClickLister lister) {
            this.mOnItemClickLister = lister;
            return this;
        }

        public ListDialog.Builder SetLastStr(int bottom) {
            this.last_str = (String) context.getText(bottom);
            return this;
        }


        public ListDialog.Builder SetLastStr(String bottom) {
            this.last_str = bottom;
            return this;
        }

        public ListDialog.Builder SetLastButton(int confirm_btnText,
                                                OnClickListener listener) {
            this.last_str = (String) context
                    .getText(confirm_btnText);
            this.Last_btnClickListener = listener;
            return this;
        }


        public ListDialog.Builder SetLastButton(String confirm_btnText,
                                                OnClickListener listener) {
            this.last_str = confirm_btnText;
            this.Last_btnClickListener = listener;
            return this;
        }

        public ListDialog create() {
            LayoutInflater inflater = (LayoutInflater) context
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            // instantiate the dialog with the custom Theme
            final ListDialog dialog = new ListDialog(context, R.style.platform_normaldialog_style);
            View layout;
            layout = inflater.inflate(R.layout.dialog_list_layout, null);

            dialog.addContentView(layout, new LayoutParams(
                    LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));

            if (last_str != null) {
                ((TextView) layout.findViewById(R.id.last_btn))
                        .setText(last_str);
                if (Last_btnClickListener != null) {
                    ((TextView) layout.findViewById(R.id.last_btn))
                            .setOnClickListener(new View.OnClickListener() {
                                public void onClick(View v) {
                                    Last_btnClickListener.onClick(dialog,
                                            DialogInterface.BUTTON_POSITIVE);
                                }
                            });
                }
            } else {
                layout.findViewById(R.id.last_btn).setVisibility(
                        View.GONE);
            }

            if (mDatas != null && mDatas.size() > 0) {
                RecyclerView dialog_list_rcv = (RecyclerView) layout.findViewById(R.id.dialog_list_rcv);
                if (adapter == null) {
                    adapter = new DialogListAdapter(mDatas, itemTextColor, context);
                } else {
                    adapter.notifyDataSetChanged();
                }
                FullyLinearLayoutManager linearLayoutManager = new FullyLinearLayoutManager(context, FullyLinearLayoutManager.VERTICAL, false);
                dialog_list_rcv.setLayoutManager(linearLayoutManager);
                dialog_list_rcv.setAdapter(adapter);
                adapter.setOnItemClickLister(new DialogListAdapter.OnItemClickLister() {
                    @Override
                    public void onItemClick(final View view, final int position) {
                        if (mOnItemClickLister != null) {
                            mOnItemClickLister.onItemClick(dialog, view, position);
//                                       itemClickLister.onClick(dialog,
//                                               DialogInterface.BUTTON_POSITIVE);
                        }
                        ;
                    }

                    @Override
                    public void onItemLongClick(View view, int position) {
                        if (mOnItemClickLister != null) {
                            mOnItemClickLister.onItemLongClick(dialog, view, position);
                        }

                    }
                });
            } else if (contentView != null) {
                // if no message set
                // add the lceContentView to the dialog body
                ((RelativeLayout) layout.findViewById(R.id.message_layout)).removeAllViews();
                ((RelativeLayout) layout.findViewById(R.id.message_layout)).addView(
                        contentView, new LayoutParams(
                                LayoutParams.WRAP_CONTENT,
                                LayoutParams.WRAP_CONTENT));

            } else {
                ((RecyclerView) layout.findViewById(R.id.dialog_list_rcv)).setVisibility(View.GONE);
            }
            dialog.setContentView(layout);
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }

    }


    @Override
    public void show() {
        if (null == mContext){
            return;
        }
        if (mContext instanceof Activity) {
            if (((Activity) mContext).isFinishing()) {
                return;
            }
        }
        super.show();
    }
}
