package com.ydl.ydlcommon.view.dialog;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.ydl.ydlcommon.R;


/**
 * Created by xiongyu on 2016/12/9.
 */
public class NormalDialog extends Dialog {

    private Context mContext;

    public NormalDialog(Context context) {
        super(context);
        mContext = context;
    }

    public NormalDialog(Context context, int theme) {
        super(context, theme);
        mContext = context;
    }

    public static class Builder {
        //是否可以点击对话框外部
        private Context context; //上下文对象
        private String title; //对话框标题
        private String message; //对话框内容
        private String confirm_btnText; //按钮名称“确定”
        private String cancel_btnText; //按钮名称“取消”
        private View contentView; //对话框中间加载的其他布局界面

        private String title_color;//标题颜色
        private String content_color;//正文颜色
        private String left_color;//左下角按钮颜色（确定）
        private String right_color;//右下角按钮颜色（取消）

        private Button left_btn;//左边取消按钮

        private NormalDialog dialog;
        String dialog_type;
        /*按钮坚挺事件*/
        private DialogInterface.OnClickListener confirm_btnClickListener;
        private DialogInterface.OnClickListener cancel_btnClickListener;
        private boolean CanceledOnTouchOutside=true;

        public Builder(Context context) {
            this.context = context;
        }
        public Builder(Context context,String dialog_type,boolean canceledOnTouchOutside) {
            this.context = context;
            this.dialog_type=dialog_type;
            CanceledOnTouchOutside=canceledOnTouchOutside;
        }

        public Builder(Context context , boolean canceledOnTouchOutside) {
            this.context = context;
            CanceledOnTouchOutside=canceledOnTouchOutside;
        }

        /**
         * 设置取消按钮的隐藏与显示
         * @return
         */
        public Builder setCancleIsVisibility(int visibility){

            if (left_btn!=null){
                left_btn.setVisibility(visibility);
            }
            return this;
        }

        /*设置对话框信息*/
        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        /**
         * Set the Dialog message from resource
         *
         * @return
         */
        public Builder setMessage(int message) {
            this.message = (String) context.getText(message);
            return this;
        }

        /**
         * Set the Dialog title from resource
         *
         * @param title
         * @return
         */
        public Builder setTitle(int title) {
            this.title = (String) context.getText(title);
            return this;
        }

        /**
         * Set the Dialog title from String
         *
         * @param title
         * @return
         */
        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setTitle_color(String title_color){
            this.title_color=title_color;
            return this;
        }

        public Builder setContent_color(String content_color){
            this.content_color=content_color;
            return this;
        }

        public Builder setLeft_color(String left_color){
            this.left_color=left_color;
            return this;
        }

        public Builder setRight_color(String right_color){
            this.right_color=right_color;
            return this;
        }

//		public Builder setCanceledOnTouchOutside(Boolean flag){
//			this.setCanceledOnTouchOutside(flag);
//			return this;
//		}

        /**
         * 设置对话框界面
         *
         * @param v View
         * @return
         */
        public Builder setContentView(View v) {
            this.contentView = v;
            return this;
        }

        /**
         * Set the positive button resource and it's listener
         *
         * @param confirm_btnText
         * @return
         */
        public Builder setPositiveButton(int confirm_btnText,
                                         DialogInterface.OnClickListener listener) {
            this.confirm_btnText = (String) context
                    .getText(confirm_btnText);
            this.confirm_btnClickListener = listener;
            return this;
        }

        /**
         * Set the positive button and it's listener
         *
         * @param confirm_btnText
         * @return
         */
        public Builder setPositiveButton(String confirm_btnText,
                                         DialogInterface.OnClickListener listener) {
            this.confirm_btnText = confirm_btnText;
            this.confirm_btnClickListener = listener;
            return this;
        }




        /**
         * Set the negative button resource and it's listener
         *
         * @return
         */
        public Builder setNegativeButton(int cancel_btnText,
                                         DialogInterface.OnClickListener listener) {
            this.cancel_btnText = (String) context
                    .getText(cancel_btnText);
            this.cancel_btnClickListener = listener;
            return this;
        }

        /**
         * Set the negative button and it's listener
         *
         * @return
         */
        public Builder setNegativeButton(String cancel_btnText,
                                         DialogInterface.OnClickListener listener) {
            this.cancel_btnText = cancel_btnText;
            this.cancel_btnClickListener = listener;
            return this;
        }

        public void dismiss(){
            if(dialog!=null){
                dialog.dismiss();
            }

        }

        @SuppressLint("WrongViewCast")
        public NormalDialog create() {
            LayoutInflater inflater = (LayoutInflater) context
                    .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            // instantiate the dialog with the custom Theme
            dialog = new NormalDialog(context, R.style.platform_normaldialog_style);
            View layout;
            if("left".equals(dialog_type)){
                layout = inflater.inflate(R.layout.dialog_common_left_layout, null);
            }else {
                layout = inflater.inflate(R.layout.dialog_normal_layout, null);
            }

            dialog.addContentView(layout, new LayoutParams(
                    LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT));
            // set the dialog title
            TextView title_tv=((TextView) layout.findViewById(R.id.title));
            TextView message_tv=((TextView) layout.findViewById(R.id.message));
            left_btn=((Button) layout.findViewById(R.id.cancel_btn));
            Button right_btn= ((Button) layout.findViewById(R.id.confirm_btn));

            if("".equals(title)||title==null){
                title_tv.setVisibility(View.GONE);
            }else {
                title_tv.setVisibility(View.VISIBLE);
                title_tv.setText(title);
                title_tv.getPaint().setFakeBoldText(true);
                if(title_color!=null&&!"".equals(title_color)){
                    title_tv.setTextColor(Color.parseColor(title_color));
                }
            }

            // set the confirm button
            if (confirm_btnText != null) {
                right_btn.setText(confirm_btnText);
                if (confirm_btnClickListener != null) {
                    right_btn.setOnClickListener(new View.OnClickListener() {
                        public void onClick(View v) {
                            confirm_btnClickListener.onClick(dialog,
                                    DialogInterface.BUTTON_POSITIVE);
                        }
                    });
                }
                if(right_color!=null&&!"".equals(right_color)){
                    right_btn.setTextColor(Color.parseColor(right_color));
                }
            } else {
                // if no confirm button just set the visibility to GONE
                right_btn.setVisibility(View.GONE);
            }
            // set the cancel button
            if(left_btn!=null){
                if (cancel_btnText != null) {
                    left_btn .setText(cancel_btnText);
                    if (cancel_btnClickListener != null) {
                        left_btn.setOnClickListener(new View.OnClickListener() {
                            public void onClick(View v) {
                                cancel_btnClickListener.onClick(dialog,
                                        DialogInterface.BUTTON_NEGATIVE);
                            }
                        });
                    }
                    if(left_color!=null&&!"".equals(left_color)){
                        left_btn.setTextColor(Color.parseColor(left_color));
                    }
                } else {
                    // if no confirm button just set the visibility to GONE

                    left_btn.setVisibility(View.GONE);

                }
            }

            // set the content message
            if (message != null) {
                message_tv.setText(message);
                if(content_color!=null&&!"".equals(content_color)){
                    message_tv.setTextColor(Color.parseColor(content_color));
                }
            } else if (contentView != null) {
                // if no message set
                // add the lceContentView to the dialog body
                ((LinearLayout) layout.findViewById(R.id.message))
                        .removeAllViews();
                ((LinearLayout) layout.findViewById(R.id.message)).addView(
                        contentView, new LayoutParams(
                                LayoutParams.WRAP_CONTENT,
                                LayoutParams.WRAP_CONTENT));
            }
            dialog.setContentView(layout);
            dialog.setCanceledOnTouchOutside(CanceledOnTouchOutside);
            dialog.setCancelable(CanceledOnTouchOutside);
            return dialog;
        }

    }

    @Override
    public void show() {
        if (null == mContext){
            return;
        }
        if (mContext instanceof Activity) {
            if (((Activity) mContext).isFinishing()) {
                return;
            }
        }
        super.show();
    }
}
