package com.yidianling.common.tools.keyboard;

import android.graphics.Rect;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;

import com.yidianling.common.tools.RxKeyboardTool;

/**
 *
 * @author Relish Wang
 * @since 2019/05/02
 */
public class GlobalLayoutListener implements ViewTreeObserver.OnGlobalLayoutListener {
    private final Rect mVisibleViewArea;
    private final int mMinKeyboardHeightDetected;

    private int mKeyboardHeight = 0;

    /**
     * Activity的根布局(Activity#setContentView方法传入的View) 或 DecorView
     */
    private View mView;
    private RxKeyboardTool.OnKeyboardChangedListener mListener;

    /**
     * @param v Activity的根布局(Activity#setContentView方法传入的View) 或 DecorView
     * @param l
     */
    public GlobalLayoutListener(View v,RxKeyboardTool.OnKeyboardChangedListener l) {
        mView = v;
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(mView.getContext().getApplicationContext());
        mVisibleViewArea = new Rect();
        mMinKeyboardHeightDetected = (int) toPixelFromDIP(60);
        mListener = l;
    }

    /**
     * Convert from DIP to PX
     */
    public static float toPixelFromDIP(float value) {
        return TypedValue.applyDimension(
                TypedValue.COMPLEX_UNIT_DIP,
                value,
                DisplayMetricsHolder.getWindowDisplayMetrics());
    }
    @Override
    public void onGlobalLayout() {
        if (mView == null) {
            return;
        }
        checkForKeyboardEvents();
    }

    private void checkForKeyboardEvents() {
        mView.getRootView().getWindowVisibleDisplayFrame(mVisibleViewArea);
        //noinspection ConstantConditions
        final int heightDiff =
                DisplayMetricsHolder.getWindowDisplayMetrics().heightPixels - mVisibleViewArea.bottom;
        if (mKeyboardHeight != heightDiff && heightDiff > mMinKeyboardHeightDetected) {
            // keyboard is now showing, or the keyboard height has changed
            mKeyboardHeight = heightDiff;
            if (mListener != null) {
                mListener.onChange(
                        true,
                        mKeyboardHeight,
                        mVisibleViewArea.width(),
                        mVisibleViewArea.bottom
                );
            }
        } else if (mKeyboardHeight != 0 && heightDiff <= mMinKeyboardHeightDetected) {
            // keyboard is now hidden
            mKeyboardHeight = 0;
            if (mListener != null) {
                mListener.onChange(
                        false,
                        mKeyboardHeight,
                        mVisibleViewArea.width(),
                        mVisibleViewArea.bottom
                );
            }
        }
    }
}