package com.ydl.utils

import android.content.Context
import android.net.Proxy
import android.os.Build
import android.text.TextUtils

/**
 * Created by Ykai on 2021/4/1.
 */
object ProxyCheckUtils {

    /**
     * 判断设备 是否使用代理上网
     * @param context 上下文对象
     * return  当前网络是否开启了代理
     */
    fun isWifiProxy(context: Context): Boolean {
        val IS_ICS_OR_LATER: Boolean = Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH
        val proxyAddress: String
        val proxyPort: Int
        if (IS_ICS_OR_LATER) {
            proxyAddress = System.getProperty("http.proxyHost")?:""
            val portStr = System.getProperty("http.proxyPort")
            proxyPort = (portStr ?: "-1").toInt()
        } else {
            proxyAddress = Proxy.getHost(context)
            proxyPort = Proxy.getPort(context)
        }
        return !TextUtils.isEmpty(proxyAddress) && proxyPort != -1
    }
}